package org.nakedobjects.nos.client.dnd.content;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.OneToManyFieldElement;
import org.nakedobjects.nos.client.dnd.UserActionSet;


public class OneToManyFieldElementImpl extends AbstractObjectContent implements OneToManyFieldElement {
    private static final Logger LOG = Logger.getLogger(OneToManyFieldElementImpl.class);
    private final NakedObject element;
    private final ObjectField field;

    public OneToManyFieldElementImpl(final NakedObject parent, final NakedObject element, final OneToManyAssociation association) {
        field = new ObjectField(parent, association);
        this.element = element;
    }

    public Consent canClear() {
        NakedObject parentObject = getParent();
        OneToManyAssociation association = getOneToManyAssociation();
        NakedObject associatedObject = getObject();
        
        Consent isEditable = isEditable();
        if (isEditable.isVetoed()) {
            return isEditable;
        }
        
        Consent isValid = association.isValidToRemove(parentObject, associatedObject);
        if (isValid.isAllowed()) {
            String status = "Clear the association to this object from '" + parentObject.titleString() + "'";
            return new Allow(status);
        } else {
            return new Veto(isValid.getReason());
        }
    }
    
    public Consent isEditable() {
        Consent usable = getField().isUsable();
        if (usable.isVetoed()) {
            return usable;
        }
        return getField().isUsable(getParent());
    }

    public Consent canSet(final NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        NakedObject parentObject = getParent();
        OneToManyAssociation association = getOneToManyAssociation();
        LOG.debug("remove " + element + " from " + parentObject);
        association.removeElement(parentObject, element);
    }

    public void debugDetails(final DebugString debug) {
        field.debugDetails(debug);
        debug.appendln("element", element);
    }

    public String getFieldName() {
        return field.getName();
    }

    public NakedObjectField getField() {
        return field.getFieldReflector();
    }

    public Naked getNaked() {
        return element;
    }

    public NakedObject getObject() {
        return element;
    }

    public Naked[] getOptions() {
        return null;
    }
    
    private OneToManyAssociation getOneToManyAssociation() {
        return (OneToManyAssociation) field.getFieldReflector();
    }

    public NakedObject getParent() {
        return field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return field.getSpecification();
    }

    public boolean isMandatory() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isOptionEnabled() {
        return false;
    }
    
    public boolean isTransient() {
        return false;
    }

    public void contentMenuOptions(final UserActionSet options) {
        // ObjectOption.menuOptions(element, options);
        super.contentMenuOptions(options);
        options.add(new ClearOneToManyAssociationOption());
    }

    public void setObject(final NakedObject object) {
    /*
     * NakedObject parentObject = getParent(); OneToManyAssociationSpecification association =
     * getOneToManyAssociation(); NakedObject associatedObject = getObject(); LOG.debug("remove " +
     * associatedObject + " from " + parentObject); association.clearAssociation(parentObject,
     * associatedObject);
     */

    }

    public String title() {
        return element.titleString();
    }

    public String toString() {
        return getObject() + "/" + field.getFieldReflector();
    }

    public String windowTitle() {
        return field.getName() + " element" + " for " + field.getParent().titleString();
    }

    public String getId() {
        return getOneToManyAssociation().getName();
    }

    public String getDescription() {
        return  field.getName() + ": " + getOneToManyAssociation().getDescription();
    }

    public String getHelp() {
        return getOneToManyAssociation().getHelp();
    }
}
// Copyright (c) Naked Objects Group Ltd.
