package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.InstanceCollectionVector;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.action.DisposeObjectOption;


public class OptionFactory {

    public static void addCreateOptions(final NakedObjectSpecification specificaton, final UserActionSet options) {
        NakedObjectAction[] actions;
        // TODO do the same as addObjectMenuOptions and collect together all the actions for all the types
        actions = specificaton.getClassActions(NakedObjectAction.USER);
        menuOptions(actions, null, options);
    }

    public static void addObjectMenuOptions(final NakedReference object, final UserActionSet options) {
        if (object != null) {
            NakedObjectAction[] actions1 = object.getSpecification().getObjectActions(NakedObjectAction.USER);
            NakedObjectAction[] actions2 = object.getSpecification().getObjectActions(NakedObjectAction.EXPLORATION);
            NakedObjectAction[] actions3 = object.getSpecification().getObjectActions(NakedObjectAction.DEBUG);
            NakedObjectAction[] actions = new NakedObjectAction[actions1.length + actions2.length + actions3.length];
            System.arraycopy(actions1, 0, actions, 0, actions1.length);
            System.arraycopy(actions2, 0, actions, actions1.length, actions2.length);
            System.arraycopy(actions3, 0, actions, actions1.length + actions2.length, actions3.length);
            menuOptions(actions, object, options);

            Oid oid = object.getOid();
            boolean isPersistent = oid != null && !oid.isTransient();
            if (!(Features.isService(object.getSpecification())) && !(object.getObject() instanceof InstanceCollectionVector)
                    && isPersistent) {
                options.add(new DisposeObjectOption());
            }
        }
    }

    private static void menuOptions(
            final NakedObjectAction[] actions,
            final NakedReference target,
            final UserActionSet menuOptionSet) {
        for (int i = 0; i < actions.length; i++) {
            UserAction option = null;
            if (actions[i].getActions().length > 0) {
                option = new UserActionSet(actions[i].getName(), menuOptionSet);
                menuOptions(actions[i].getActions(), target, (UserActionSet) option);

            } else {                
                int noOfParameters = actions[i].getParameterTypes().length;
                if (noOfParameters == 0) {
                    option = ImmediateObjectOption.createOption(actions[i], target);
                } else if (actions[i].isContributedMethodWithSuitableParameter() && noOfParameters == 1 && target != null && target.getSpecification().isOfType(actions[i].getParameterTypes()[0])) {
                    option = ImmediateObjectOption.createServiceOption(actions[i], target);
                } else {
                    option = DialoggedObjectOption.createOption(actions[i], target);
                }
            }
            if (option != null) {
                menuOptionSet.add(option);
            }
        }
    }
}

// Copyright (c) Naked Objects Group Ltd.
