package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;


public class RootCollection extends AbstractCollectionContent {
    private final NakedCollection collection;

    public RootCollection(final NakedCollection collection) {
        this.collection = collection;
    }

    public Consent canClear() {
        return Veto.DEFAULT;
    }

    public Consent canSet(final NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public void debugDetails(final DebugString debug) {
        debug.appendln("collection", collection);
        super.debugDetails(debug);
    }

    public NakedCollection getCollection() {
        return collection;
    }

    public boolean isCollection() {
        return true;
    }

    public String getHelp() {
        return "No help for this collection";
    }

    public String getIconName() {
        return null;
    }

    public String getId() {
        return "";
    }

    public Naked getNaked() {
        return collection;
    }

    public NakedObjectSpecification getSpecification() {
        return collection.getSpecification();
    }

    public boolean isTransient() {
        return collection != null;
    }

    public void setObject(final NakedObject object) {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public String title() {
        return collection.titleString();
    }

    public String windowTitle() {
        return collection.titleString();
    }

    public String toString() {
        return "Root Collection: " + collection;
    }

    public Naked drop(final Content sourceContent) {
        return null;
    }

    public Consent canDrop(final Content sourceContent) {
        return Veto.DEFAULT;
    }

    public Image getIconPicture(final int iconHeight) {
        // return ImageFactory.getInstance().loadObjectIcon(getSpecification(), "", iconHeight);
        return ImageFactory.getInstance().loadIcon("root-collection", iconHeight, null);
    }
}
// Copyright (c) Naked Objects Group Ltd.
