package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.Perspective;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;


public class RootObject extends AbstractObjectContent {
    private final NakedObject object;

    public RootObject(final NakedObject object) {
        this.object = object;
    }

    public Consent canClear() {
        return Veto.DEFAULT;
    }

    public Consent canDrop(Content sourceContent) {
        if (object.getObject() instanceof Perspective) {
            return Allow.DEFAULT;
        } else {
            return super.canDrop(sourceContent);
        }
    }
    
    public Consent canSet(final NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public void debugDetails(final DebugString debug) {
        debug.appendln("object", object);
    }

    public Naked getNaked() {
        return object;
    }

    public String getDescription() {
        return  getSpecification().getSingularName() + ": " + getObject().titleString() + " " + getSpecification().getDescription();
    }

    public String getHelp() {
        return "";
    }

    public String getId() {
        return "";
    }

    public NakedObject getObject() {
        return object;
    }
    
    public Naked[] getOptions() {
        return null;
    }

    public NakedObjectSpecification getSpecification() {
        return object.getSpecification();
    }

    public boolean isObject() {
        return true;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public boolean isTransient() {
        return object != null && object.getResolveState().isTransient();
    }

    public void setObject(final NakedObject object) {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public String title() {
        return object.titleString();
    }

    public String toString() {
        return "Root Object: " + object;
    }

    public String windowTitle() {
        return (isTransient() ? "UNSAVED " : "") + getSpecification().getSingularName();
    }
}
// Copyright (c) Naked Objects Group Ltd.
