package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;


public class ServiceObject extends AbstractContent {
    private final NakedObject object;

    public ServiceObject(final NakedObject object) {
        this.object = object;
    }

    public Consent canClear() {
        return Veto.DEFAULT;
    }

    public Consent canSet(final NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public void debugDetails(final DebugString debug) {
        debug.appendln("service", object);
    }

    public Naked getNaked() {
        return object;
    }

    public String getDescription() {
        String specName = getSpecification().getSingularName();
        String objectTitle = getObject().titleString();
        return specName + (specName.equalsIgnoreCase(objectTitle) ? "" : ": " + objectTitle) + " "
                + getSpecification().getDescription();
    }

    public String getHelp() {
        return "";
    }

    public String getId() {
        return "";
    }

    public NakedObject getObject() {
        return object;
    }
    
    public Naked[] getOptions() {
        return null;
    }

    public NakedObjectSpecification getSpecification() {
        return object.getSpecification();
    }

    public boolean isObject() {
        return false;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public boolean isTransient() {
        return object != null && object.getResolveState().isTransient();
    }

    public void setObject(final NakedObject object) {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public String title() {
        return object.titleString();
    }

    public String toString() {
        return "Root Object: " + object;
    }

    public String windowTitle() {
        return (isTransient() ? "UNSAVED " : "") + getSpecification().getSingularName();
    }

    public Consent canDrop(Content sourceContent) {
        return Veto.DEFAULT;
    }

    public Naked drop(Content sourceContent) {
        return null;
    }

    public String getIconName() {
        NakedObject object = getObject();
        return object == null ? null : object.getIconName();
    }

    public Image getIconPicture(int iconHeight) {
        NakedObject nakedObject = getObject();
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        return icon;
    }

    public void parseTextEntry(String entryText) {
        throw new UnexpectedCallException();
    }
    
    public void viewMenuOptions(final UserActionSet options) {}
    
}
// Copyright (c) Naked Objects Group Ltd.
