package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ValueField;


public class ValueFieldImpl extends AbstractValueContent implements ValueField {
    private final ObjectField field;
    private final NakedValue valueAdapter;

    public ValueFieldImpl(final NakedObject parent, final NakedValue object, final ValueAssociation association) {
        field = new ObjectField(parent, association);
        Assert.assertNotNull(object);
        this.valueAdapter = object;
    }

    public Consent canDrop(final Content sourceContent) {
        return Veto.DEFAULT;
    }
    
    public boolean canClear() {
        return getValueAssociation().canClear();
    }
    
    public boolean canWrap() {
        return getValueAssociation().canWrap();
    }

    public void clear() {
        valueAdapter.clear();
    }

    public void debugDetails(final DebugString debug) {
        field.debugDetails(debug);
        debug.appendln("object", valueAdapter);
    }

    public Naked drop(final Content sourceContent) {
        return null;
    }

    public void entryComplete() {
        if (valueAdapter.isEmpty()) {
            getValueAssociation().clearValue( getParent());            
        } else {
            getValueAssociation().setValue( getParent(), valueAdapter);
        }
    }

    public String getDescription() {
        String title = valueAdapter == null ? "" :  ": " + valueAdapter.titleString();
        String name = field.getName();
        NakedObjectSpecification specification = getSpecification();
        String type = name.indexOf(specification .getShortName()) == -1 ? "" : " (" + specification.getShortName() + ")";
        String description = getValueAssociation().getDescription();
        return name + type + title + " " + description;
    }

    public String getHelp() {
        return field.getHelp();
    }

    public String getFieldName() {
        return field.getName();
    }

    public NakedObjectField getField() {
        return field.getFieldReflector();
    }

    public String getIconName() {
        return valueAdapter.getIconName();
    }

    public Naked getNaked() {
        return valueAdapter;
    }

    public String getId() {
        return field.getName();
    }

    public NakedValue getObject() {
        return valueAdapter;
    }

    public Naked[] getOptions() {
        return getValueAssociation().getOptions(getParent());
    }
    
    private ValueAssociation getValueAssociation() {
        return (ValueAssociation) getField();
    }

    public int getMaximumLength() {
        return getValueAssociation().getMaximumLength();
    }
    
    public int getTypicalLineLength() {
        return getValueAssociation().getTypicalLineLength();
    }
    
    public int getNoLines() {
        return getValueAssociation().getNoLines();
    }
    
    public NakedObject getParent() {
        return field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return getValueAssociation().getSpecification();
    }

    public Consent isEditable() {
        Consent usable = getValueAssociation().isUsable();
        if (usable.isVetoed()) {
            return usable;
        }
        return getValueAssociation().isUsable(getParent());
    }

    public boolean isEmpty() {
        return getField().isEmpty(getParent());
    }
    
    public boolean isMandatory() {
        return getValueAssociation().isMandatory();
    }
    
    public boolean isOptionEnabled() {
        return getValueAssociation().isOptionEnable();
    }

    public void parseTextEntry(final String entryText) {
        String existingEntry = valueAdapter.asEncodedString();
        valueAdapter.parseTextEntry(entryText);
        Consent valid = ((ValueAssociation) getField()).isValueValid(getParent(), valueAdapter);
        if (valid.isVetoed()) {
            valueAdapter.restoreFromEncodedString(existingEntry);
            throw new InvalidEntryException(valid.getReason());
        }
        if (getValueAssociation().isMandatory() && valueAdapter.isEmpty()) {
            valueAdapter.restoreFromEncodedString(existingEntry);
            throw new InvalidEntryException("Mandatory field cannot be empty");
        }
    }

    public String title() {
        return field.getName();
    }

    public String toString() {
        return (valueAdapter == null ? "null" : valueAdapter.titleString()) + "/" + getField();
    }

    public String windowTitle() {
        return title();
    }
}
// Copyright (c) Naked Objects Group Ltd.
