package org.nakedobjects.nos.client.dnd.debug;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;


public class DebugBorder extends AbstractBorder {
    public DebugBorder(final View wrappedView) {
        super(wrappedView);

        bottom = Toolkit.getText("debug").getTextHeight();
    }

    protected void debugDetails(final DebugString debug) {
        debug.append("DebugBorder");
    }

    public void draw(final Canvas canvas) {
        String debug = getView() + " " + getState();
        int baseline = wrappedView.getSize().getHeight() + Toolkit.getText("debug").getAscent();
        Color color = Toolkit.getColor("debug.baseline");
        canvas.drawText(debug, 0, baseline, color, Toolkit.getText("debug"));

        super.draw(canvas);
    }

    public String toString() {
        return wrappedView.toString() + "/DebugBorder";
    }

    public void firstClick(final Click click) {
        new DebugOption().execute(getWorkspace(), getView(), click.getLocation());
    }
}
// Copyright (c) Naked Objects Group Ltd.
