package org.nakedobjects.nos.client.dnd.debug;

import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;


public class DebugContent implements DebugInfo {
    private final View view;

    public DebugContent(final View display) {
        this.view = display;
    }

    public void debugData(final DebugString debug) {
        Content content = view.getContent();
        if (content != null) {
            String type = content.getClass().getName();
            type = type.substring(type.lastIndexOf('.') + 1);
            debug.appendln("Content", type);

            debug.indent();

            content.debugDetails(debug);

            debug.appendln("Icon name", content.getIconName());
            debug.appendln("Icon ", content.getIconPicture(32));
            debug.appendln("Window title", content.windowTitle());

            debug.appendln("Object", content.isObject());
            debug.appendln("Collection", content.isCollection());
            debug.appendln("Value", content.isValue());

            debug.unindent();
        } else {
            debug.appendln("Content", "none");
        }
        debug.blankLine();
    }

    public String debugTitle() {
        return "Content";
    }
}
// Copyright (c) Naked Objects Group Ltd.
