package org.nakedobjects.nos.client.dnd.debug;

import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;


public class DebugDrawing implements DebugInfo {
    private final View view;

    public DebugDrawing(final View display) {
        this.view = display;
    }

    public void debugData(final DebugString debug) {
        view.draw(new DebugCanvas(debug, new Bounds(view.getBounds())));
    }

    public String debugTitle() {
        return "Drawing";
    }
}
// Copyright (c) Naked Objects Group Ltd.
