package org.nakedobjects.nos.client.dnd.debug;

import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;


public class DebugDrawingAbsolute implements DebugInfo {
    private final View view;

    public DebugDrawingAbsolute(final View display) {
        this.view = display;
    }

    public void debugData(final DebugString debug) {
        view.draw(new DebugCanvasAbsolute(debug, new Bounds(view.getAbsoluteLocation(), view.getSize())));
    }

    public String debugTitle() {
        return "Drawing (Absolute)";
    }
}
// Copyright (c) Naked Objects Group Ltd.
