package org.nakedobjects.nos.client.dnd.debug;

import java.util.Enumeration;

import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.logging.SnapshotAppender;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;


/**
 * Display debug window
 */
public class DebugDumpSnapshotOption extends AbstractUserAction {
    public DebugDumpSnapshotOption() {
        super("Dump log snapshot", UserAction.DEBUG);
    }

    public Consent disabled(final View component) {
        Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender) enumeration.nextElement();
            if (appender instanceof SnapshotAppender) {
                return Allow.DEFAULT;
            }
        }
        return new Veto("No available snapshot appender");
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender) enumeration.nextElement();
            if (appender instanceof SnapshotAppender) {
                ((SnapshotAppender) appender).forceSnapshot();
            }
        }
    }

    public String getDescription(final View view) {
        return "Force a snapshot of the log";
    }
}
// Copyright (c) Naked Objects Group Ltd.
