package org.nakedobjects.nos.client.dnd.debug;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.Dump;


public class DebugObjectGraph implements DebugInfo {
    private final Naked object;

    public DebugObjectGraph(final Naked object) {
        this.object = object;
    }

    public void debugData(final DebugString debug) {
        if (object instanceof NakedObject) {
            NakedObject obj = (NakedObject) object;
            dumpGraph(obj, debug);

        } else if (object instanceof NakedCollection) {
            NakedCollection collection = (NakedCollection) object;
            dumpGraph(collection, debug);
        }
    }

    public String debugTitle() {
        return "Object Graph";
    }

    private void dumpGraph(final Naked object, final DebugString info) {
        if (object != null) {
            Dump.graph(object, info);
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
