package org.nakedobjects.nos.client.dnd.debug;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.InfoDebugFrame;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;


/**
 * Display debug window
 */
public class DebugOption extends AbstractUserAction {
    public DebugOption() {
        super("Debug...", UserAction.DEBUG);
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        InfoDebugFrame f = new InfoDebugFrame();
        Content content = view.getContent();
        Naked object = content == null ? null : content.getNaked();

        DebugInfo[] objectPanes = object == null ? new DebugInfo[0] : new DebugInfo[] { new DebugAdapter(object),
                new DebugObjectGraph(object), new DebugObjectSpecification(object) };

        DebugInfo[] viewPanes = new DebugInfo[] { new DebugViewStructure(view), new DebugContent(view), new DebugDrawing(view),
                new DebugDrawingAbsolute(view) };

        int noObjectPanes = objectPanes.length;
        int noViewPanes = viewPanes.length;
        DebugInfo[] panes = new DebugInfo[noObjectPanes + noViewPanes];
        System.arraycopy(objectPanes, 0, panes, 0, noObjectPanes);
        System.arraycopy(viewPanes, 0, panes, noObjectPanes, noViewPanes);

        f.setInfo(panes);
        f.show(at.getX() + 50, at.getY() + 6);
    }

    public String getDescription(final View view) {
        return "Open debug window about " + view;
    }
}
// Copyright (c) Naked Objects Group Ltd.
