package org.nakedobjects.nos.client.dnd.focus;

import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.WindowBorder;

public class SubviewFocusManager extends AbstractFocusManager {
    private final WindowBorder windowBorder;

    public SubviewFocusManager(final WindowBorder container) {
        super(container);
        windowBorder = container;
    }

    public SubviewFocusManager(final View container) {
        super(container);
        windowBorder = null;
    }

    public SubviewFocusManager(final View container, final View initalFocus) {
        super(container, initalFocus);
        windowBorder = null;
    }

    protected View[] getChildViews() {
        View[] subviews = container.getSubviews();
        View[] buttons = windowBorder == null ? new View[0] : windowBorder.getButtons();
    //    View[] buttons = new View[0];
                                                         
        View[] views = new View[subviews.length + buttons.length];
        System.arraycopy(subviews, 0, views, 0, subviews.length);
        System.arraycopy(buttons, 0, views, subviews.length, buttons.length);
        return views;
        
        //return container.getSubviews();
    }

}
// Copyright (c) Naked Objects Group Ltd.
