package org.nakedobjects.nos.client.dnd.list;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.border.WindowBorder;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.CollectionElementBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;
import org.nakedobjects.nos.client.dnd.focus.SubviewFocusManager;


public class ListSpecification extends AbstractCompositeViewSpecification implements SubviewSpec {

    public ListSpecification() {
        builder = new StackLayout(new CollectionElementBuilder(this));
    }

    public View createView(final Content content, final ViewAxis axis) {
        WindowBorder newView = new WindowBorder(super.createView(content, axis), true);
        newView.setFocusManager(new SubviewFocusManager(newView));
        return newView;
    }

    public View createSubview(final Content content, final ViewAxis axis) {
        return Toolkit.getViewFactory().createFieldView((ObjectContent) content, axis);
    }

    public String getName() {
        return "List";
    }

    public boolean canDisplay(final Content content) {
        return content.isCollection();
    }
}
// Copyright (c) Naked Objects Group Ltd.
