package org.nakedobjects.nos.client.dnd.lookup;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.builder.AbstractViewBuilder;
import org.nakedobjects.nos.client.dnd.view.simple.CompositeView;

public class DropDownListBuilder extends AbstractViewBuilder {
    private final SubviewSpec subviewSpecification;

    public DropDownListBuilder(SubviewSpec subviewSpecification) {
        this.subviewSpecification = subviewSpecification;}

    public void build(View view) {
        Content content = view.getContent();
        Naked[] options = content.getOptions();
        
        // TODO sort list
        
        for (int i = 0; i < options.length; i++) {
            Content subContent = new OptionContent(options[i]);
            View subview = subviewSpecification.createSubview(subContent, view.getViewAxis());
            view.addView(subview);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        CompositeView view = new CompositeView(content, specification, axis);
        view.setCanDragView(false);
        return view;
    }

}


// Copyright (c) Naked Objects Group Ltd.
