package org.nakedobjects.nos.client.dnd.lookup;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractViewDecorator;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;


class DropDownSelection extends AbstractViewDecorator {

    protected DropDownSelection(final View wrappedView) {
        super(wrappedView);
    }

    public void draw(final Canvas canvas) {
        if (getState().isViewIdentified()) {
            Color color = Toolkit.getColor("secondary3");
            canvas.clearBackground(this, color);
        }
        canvas.offset(HPADDING, 0);
        super.draw(canvas);
    }

    public void entered() {
        getState().setContentIdentified();
        getState().setViewIdentified();
        wrappedView.entered();
        markDamaged();
    }

    public void exited() {
        getState().clearObjectIdentified();
        getState().clearViewIdentified();
        wrappedView.exited();
        markDamaged();
    }

    public void firstClick(final Click click) {
        DropDownAxis axis = (DropDownAxis) getViewAxis();
        axis.setSelection((OptionContent) getContent());
        View view = axis.getOriginalView();
//        getParent().dispose();
        view.getParent().updateView();
        view.getParent().invalidateContent();
    }

    public Size getRequiredSize(final Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.extendWidth(HPADDING * 2);
        return size;
    }
}
// Copyright (c) Naked Objects Group Ltd.
