package org.nakedobjects.nos.client.dnd.lookup;

import java.awt.event.KeyEvent;

import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Shape;
import org.nakedobjects.nos.client.dnd.drawing.Size;


/**
 * Field border that provides a drop-down list.
 */
public abstract class OpenDropDownBorder extends AbstractBorder {
    private boolean over;

    public OpenDropDownBorder(final View wrappedView) {
        super(wrappedView);
        right = 18;
    }

    protected abstract View createOverlay();

    public void draw(final Canvas canvas) {
        Size size = getSize();
        int x = size.getWidth() - right + 5 - HPADDING;
        int y = (size.getHeight() - 6) / 2;

        if (isAvailable()) {
            Shape triangle = new Shape(0, 0);
            triangle.addVertex(6, 6);
            triangle.addVertex(12, 0);

            canvas.drawShape(triangle, x, y, Toolkit.getColor("secondary2"));
            if (over) {
                Color color = over ? Toolkit.getColor("secondary1") : Toolkit.getColor("primary2");
                canvas.drawSolidShape(triangle, x, y, color);
            }
        }

        super.draw(canvas);
    }

    public void exited() {
        if (over) {
            markDamaged();
        }
        over = false;
        super.exited();
    }

    public void firstClick(final Click click) {
        float x = click.getLocation().getX() - 2;
        float boundary = getSize().getWidth() - right;
        if (x >= boundary) {
            if (isAvailable()) {
                open();
            }
        } else {
            super.firstClick(click);
        }
    }

    public Size getRequiredSize(final Size maximumSize) {
        maximumSize.contractWidth(HPADDING);
        Size size = super.getRequiredSize(maximumSize);
        size.extendWidth(HPADDING);
        return size;
    }

    protected boolean isAvailable() {
        return true;
    }
    
    public boolean canFocus() {
        return isAvailable();
    }

    public void keyPressed(final KeyboardAction key) {
        if (key.getKeyCode() == KeyEvent.VK_DOWN && isAvailable()) {
            open();
            key.consume();
        }

        super.keyPressed(key);
    }

    public void mouseMoved(final Location at) {
        if (at.getX() >= getSize().getWidth() - right) {
            getFeedbackManager().showDefaultCursor();
            if (!over) {
                markDamaged();
            }
            over = true;
        } else {
            if (over) {
                markDamaged();
            }
            over = false;
            super.mouseMoved(at);
        }
    }

    private void open() {

        BackgroundThread.run(this, new BackgroundTask() {
            public void execute() {
                View overlay = createOverlay();
                /*
                 * Size size = overlay.getRequiredSize(new Size()); size.ensureWidth(getSize().getWidth());
                 * overlay.setSize(size);
                 */
                Location location = getView().getAbsoluteLocation();
                location.add(getView().getPadding().getLeft() - 1, getSize().getHeight() + 2);
                overlay.setLocation(location);

                // overlay.layout(new Size());
                getViewManager().setOverlayView(overlay);
            }

            public String getDescription() {
                return "";
            }

            public String getName() {
                return "Opening lookup";
            }
        });
    }
}
// Copyright (c) Naked Objects Group Ltd.
