package org.nakedobjects.nos.client.dnd.lookup;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.OneToOneField;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.View;


public class OpenObjectDropDownBorder extends OpenDropDownBorder {
    private static final DropDownObjectOverlaySpecification spec = new DropDownObjectOverlaySpecification();

    public OpenObjectDropDownBorder(final View wrappedView) {
        super(wrappedView);
    }

    protected View createOverlay() {
        ObjectContent content = (ObjectContent) getContent();
        return spec.createView(getContent(), new ObjectDropDownAxis(content, getView()));
    }

    protected boolean isAvailable() {
        Content content = getContent();
        if (content instanceof OneToOneField) {
            OneToOneField oneToOneField = ((OneToOneField) content);
            return oneToOneField.isEditable().isAllowed();
        } else if (content instanceof ParameterContent) {
            return true;
        } else {
            return false;
        }

    }
}
// Copyright (c) Naked Objects Group Ltd.
