package org.nakedobjects.nos.client.dnd.lookup;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ValueField;
import org.nakedobjects.nos.client.dnd.View;


public class OpenValueDropDownBorder extends OpenDropDownBorder {
    private static final DropDownObjectOverlaySpecification spec = new DropDownValueOverlaySpecification();

    public OpenValueDropDownBorder(final View wrappedView) {
        super(wrappedView);
    }

    protected View createOverlay() {
       ValueContent content = (ValueContent) getContent();
       return spec.createView(getContent(), new ValueDropDownAxis(content, getView()));
    }

    protected boolean isAvailable() {
        Content content = getContent();
        if (content instanceof ValueField) {
            ValueField oneToOneField = ((ValueField) content);
            return oneToOneField.isEditable().isAllowed();
        } else if (content instanceof ParameterContent) {
            return true;
        } else {
            return false;
        }

    }
}
// Copyright (c) Naked Objects Group Ltd.
