package org.nakedobjects.nos.client.dnd.notifier;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.content.RootCollection;


public class ViewUpdateNotifier implements DebugInfo {
    private static final Logger LOG = Logger.getLogger(ViewUpdateNotifier.class);
    protected Hashtable views = new Hashtable();

    public void add(final View view) {
        Content content = view.getContent();
        if (content != null && content.isObject()) {
            Naked object = content.getNaked();

            if (object != null) {
                Vector viewsToNotify;

                if (views.containsKey(object)) {
                    viewsToNotify = (Vector) views.get(object);
                } else {
                    viewsToNotify = new Vector();
                    views.put(object, viewsToNotify);
                }

                if (viewsToNotify.contains(view)) {
                    throw new NakedObjectRuntimeException(view + " already being notified");
                }
                viewsToNotify.addElement(view);
                LOG.debug("added " + view + " to observers for " + object);
            }
        }
    }

    public void debugData(final DebugString buf) {
        Enumeration f = views.keys();

        while (f.hasMoreElements()) {
            Object object = f.nextElement();

            Vector viewsToNotify = (Vector) views.get(object);
            Enumeration e = viewsToNotify.elements();
            buf.append("Views for " + object + " \n");

            while (e.hasMoreElements()) {
                View view = (View) e.nextElement();
                buf.append("        " + view);
                buf.append("\n");
            }
            buf.append("\n");
        }
    }

    public String debugTitle() {
        return "Views for object details (observers)";
    }

    public void remove(final View view) {
        Content content = view.getContent();
        if (content != null && content.isObject()) {
            LOG.debug("removing " + content + " for " + view);
            Naked object = ((ObjectContent) content).getObject();
            if (object != null) {
                if (views.containsKey(object)) {
                    Vector viewsToNotify;
                    viewsToNotify = (Vector) views.get(object);
                    Enumeration e = viewsToNotify.elements();
                    while (e.hasMoreElements()) {
                        View v = (View) e.nextElement();
                        if (view == v.getView()) {
                            viewsToNotify.remove(v);
                            LOG.debug("removed " + view + " from observers for " + object);
                            break;
                        }
                    }

                    if (viewsToNotify.size() == 0) {
                        views.remove(object);
                        LOG.debug("removed observer list for " + object);

                        // TODO need to do garbage collection instead
                        // NakedObjectLoader loader = NakedObjects.getObjectLoader();
                        // loader.unloaded((NakedObject) object);
                    }
                } else {
                    throw new NakedObjectRuntimeException("Tried to remove a non-existant view " + view + " from observers for "
                            + object);
                }
            }
        }
    }

    public void shutdown() {
        views.clear();
    }

    public void invalidateViewsForChangedObjects() {
        Enumeration objects = NakedObjectsContext.getUpdateNotifer().allChangedObjects();
        while (objects.hasMoreElements()) {
            NakedObject object = (NakedObject) objects.nextElement();
            LOG.debug("invalidate views for " + object);
            Object viewsVector = this.views.get(object);
            if (viewsVector == null) {
                continue;
            }
            Enumeration views = ((Vector) viewsVector).elements();
            while (views.hasMoreElements()) {
                View view = (View) views.nextElement();
                LOG.debug("   - " + view);
                view.getView().invalidateContent();
            }
        }
    }

    public void removeViewsForDisposedObjects() {
        Enumeration objects = NakedObjectsContext.getUpdateNotifer().allDisposedObjects();
        while (objects.hasMoreElements()) {
            NakedObject objectToDispose = (NakedObject) objects.nextElement();
            LOG.debug("dispose views for " + objectToDispose);
            Vector viewsForObject = (Vector) views.get(objectToDispose);
            if (viewsForObject != null) {
                removeViews(viewsForObject);
                Vector remainingViews = (Vector) views.get(objectToDispose);
                if (remainingViews != null && remainingViews.size() > 0) {
                    NakedObjectsContext.getMessageBroker().addWarning(
                            "There are still views (within other views) for the disposed object " + objectToDispose.titleString()
                                    + ".  Only objects that are shown as root views can be properly disposed of");
                } else {
                    NakedObjectsContext.getObjectLoader().unloaded(objectToDispose);
                }
            }
        }
    }

    private void removeViews(Vector views) {
        View[] viewsArray = new View[views.size()];
        views.copyInto(viewsArray);
        View[] viewsOnWorkspace = viewsArray[0].getWorkspace().getSubviews();
        for (int i = 0; i < viewsArray.length; i++) {
            View view = viewsArray[i].getView();
            for (int j = 0; j < viewsOnWorkspace.length; j++) {
                if (view == viewsOnWorkspace[j]) {
                    LOG.debug("   (root removed) " + view);
                    view.getView().dispose();
                    break;
                }
            }

            for (int j = 0; j < viewsOnWorkspace.length; j++) {
                if (viewsOnWorkspace[j].getContent() instanceof RootCollection) {
                    View[] subviewsOfRootView = viewsOnWorkspace[j].getSubviews();
                    for (int k = 0; k < subviewsOfRootView.length; k++) {
                        if (subviewsOfRootView[k] == view) {
                            LOG.debug("   (element removed) " + view);
                            view.getView().dispose();
                        }
                    }
                }
            }
            
            for (int j = 0; j < viewsOnWorkspace.length; j++) {
                if (viewsOnWorkspace[j].contains(view)) {
                    LOG.debug("   (invalidated) " + view);
                    View parent = view.getParent();
                    parent.invalidateContent();
                }
            }
            
            


        }

    }

}
// Copyright (c) Naked Objects Group Ltd.
