package org.nakedobjects.nos.client.dnd.table;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.value.ImageValue;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.CollectionElementBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;


public abstract class AbstractTableSpecification extends AbstractCompositeViewSpecification implements SubviewSpec {
    private static final Logger LOG = Logger.getLogger(AbstractTableSpecification.class);

    private ViewSpecification rowSpecification;

    public AbstractTableSpecification() {
        builder = new StackLayout(new CollectionElementBuilder(this));
    }

    public boolean canDisplay(final Content content) {
        if (content.isCollection()) {
            NakedCollection coll = (NakedCollection) ((CollectionContent) content).getCollection();
            NakedObjectSpecification elementSpecification = coll.getElementSpecification();
            NakedObjectField[] fields = elementSpecification.getStaticallyVisibleFields();
            for (int i = 0; i < fields.length; i++) {
                if (fields[i].isObject() || fields[i].isValue()) {
                    return true;
                }
            }
            return false;
        } else {
            return false;
        }
    }

    public View createSubview(final Content content, final ViewAxis axis) {
        return rowSpecification.createView(content, axis);
    }

    public final View createView(Content content, ViewAxis axis) {
        NakedCollection coll = (NakedCollection) ((CollectionContent) content).getCollection();
        NakedObjectSpecification elementSpecification = coll.getElementSpecification();

        NakedObjectField[] accessibleFields = elementSpecification.getStaticallyVisibleFields();
        TableAxis tableAxis = new TableAxis(tableFields(accessibleFields));
        // TODO make the setting of the column width strategy external so it can be changed
        tableAxis.setupColumnWidths(new TypeBasedColumnWidthStrategy());

        View table = super.createView(content, tableAxis);
        tableAxis.setRoot(table);

        rowSpecification = new TableRowSpecification();
        // rowSpecification.

        return doCreateView(table, content, axis);
    }

    protected abstract View doCreateView(final View table, final Content content, final ViewAxis axis);

    public String getName() {
        return "Standard Table";
    }

    public boolean isReplaceable() {
        return false;
    }

    private NakedObjectField[] tableFields(final NakedObjectField[] viewFields) {
        for (int i = 0; i < viewFields.length; i++) {
            if (viewFields[i].getSpecification().isOfType(
                    NakedObjectsContext.getReflector().loadSpecification(ImageValue.class))) {
                continue;
            }
            if (!viewFields[i].isVisible()) {
                continue;
            }
            LOG.debug("column " + viewFields[i].getSpecification());
            // if(viewFields[i].getSpecification().isOfType(NakedObjects.getSpecificationLoader().lo));
        }

        NakedObjectField[] tableFields = new NakedObjectField[viewFields.length];
        int c = 0;
        for (int i = 0; i < viewFields.length; i++) {
            if (!(viewFields[i] instanceof OneToManyAssociation)) {
                tableFields[c++] = viewFields[i];
            }
        }

        NakedObjectField[] results = new NakedObjectField[c];
        System.arraycopy(tableFields, 0, results, 0, c);
        return results;
    }
}
// Copyright (c) Naked Objects Group Ltd.
