package org.nakedobjects.nos.client.dnd.table;

import org.nakedobjects.noa.reflect.NakedObjectField;


public class DefaultColumnWidthStrategy implements ColumnWidthStrategy {

    private int minimum;
    private int preferred;
    private int maximum;

    public DefaultColumnWidthStrategy() {
        this(18, 70, 250);
    }

    public DefaultColumnWidthStrategy(final int minimum, final int preferred, final int maximum) {
        if (minimum <= 0) {
            throw new IllegalArgumentException("minimum width must be greater than zero");
        }
        if (preferred <= minimum || preferred >= maximum) {
            throw new IllegalArgumentException("preferred width must be greater than minimum and less than maximum");
        }
        this.minimum = minimum;
        this.preferred = preferred;
        this.maximum = maximum;
    }

    public int getMinimumWidth(final int i, final NakedObjectField specification) {
        return minimum;
    }

    public int getPreferredWidth(final int i, final NakedObjectField specification) {
        return preferred;
    }

    public int getMaximumWidth(final int i, final NakedObjectField specification) {
        return maximum;
    }
}
// Copyright (c) Naked Objects Group Ltd.
