package org.nakedobjects.nos.client.dnd.table;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;


public class TableRowSpecification extends AbstractCompositeViewSpecification {
    public TableRowSpecification() {
        builder = new TableCellBuilder();
    }

    public boolean canDisplay(final Content content) {
        return content.isObject();
    }

    public View createView(final Content content, final ViewAxis axis) {
        resolveObject(content);
        View view = super.createView(content, axis);
        return new TableRowBorder(view);
    }

    public String getName() {
        return "Table Row";
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return true;
    }
}
// Copyright (c) Naked Objects Group Ltd.
