package org.nakedobjects.nos.client.dnd.table;

import java.util.Hashtable;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public class TypeBasedColumnWidthStrategy implements ColumnWidthStrategy {
    private static final NakedObjectSpecification NAKEDOBJECT = NakedObjectsContext.getReflector().loadSpecification(
            NakedObject.class);
    private Hashtable types = new Hashtable();

    public TypeBasedColumnWidthStrategy() {
    /*
     * NakedObjectSpecificationLoader loader = NakedObjects.getSpecificationLoader();
     * addWidth(loader.loadSpecification(Logical.class), 25); addWidth(loader.loadSpecification(Date.class),
     * 65); addWidth(loader.loadSpecification(Time.class), 38);
     * addWidth(loader.loadSpecification(DateTime.class), 100);
     * addWidth(loader.loadSpecification(TextString.class), 80);
     */
    }

    public void addWidth(final NakedObjectSpecification specification, final int width) {
        types.put(specification, new Integer(width));
    }

    public int getMaximumWidth(final int i, final NakedObjectField specification) {
        return 0;
    }

    public int getMinimumWidth(final int i, final NakedObjectField specification) {
        return 15;
    }

    public int getPreferredWidth(final int i, final NakedObjectField specification) {
        NakedObjectSpecification type = specification.getSpecification();
        if (type == null) {
            return 200;
        }
        Integer t = (Integer) types.get(type);
        if (t != null) {
            return t.intValue();
        } else if (type.isOfType(NAKEDOBJECT)) {
            return 120;
        } else {
            return 100;
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
