package org.nakedobjects.nos.client.dnd.table;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.basic.TableFocusManager;
import org.nakedobjects.nos.client.dnd.border.ScrollBorder;
import org.nakedobjects.nos.client.dnd.border.WindowBorder;
import org.nakedobjects.nos.client.dnd.builder.CollectionElementBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;


public class WindowTableSpecification extends org.nakedobjects.nos.client.dnd.table.AbstractTableSpecification {
    public WindowTableSpecification() {
        builder = new StackLayout(new CollectionElementBuilder(this));
    }

    public View doCreateView(final View view, final Content content, final ViewAxis axis) {
        ScrollBorder scrollingView = new ScrollBorder(view);
        WindowBorder viewWithWindowBorder = new WindowBorder(scrollingView, false);
        // note - the next call needs to be after the creation of the window border so
        // that it exists when the header is set up
        scrollingView.setTopHeader(new TableHeader(content, view.getViewAxis()));
        viewWithWindowBorder.setFocusManager(new TableFocusManager(viewWithWindowBorder));
        return viewWithWindowBorder;
    }

    public String getName() {
        return "Table";
    }

}
// Copyright (c) Naked Objects Group Ltd.
