package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;


/**
 * Specification for a tree node that will display a closed collection as a root node or within an object.
 * 
 * @see org.nakedobjects.nos.client.dnd.tree.OpenCollectionNodeSpecification for displaying an open collection
 *      within an object.
 */
public class ClosedCollectionNodeSpecification extends NodeSpecification {
    public boolean canDisplay(final Content content) {
        return content.isCollection() && content.getNaked() != null;
    }

    public int canOpen(final Content content) {
        NakedCollection collection = ((CollectionContent) content).getCollection();
        if (collection.getResolveState().isGhost()) {
            return UNKNOWN;
        } else {
            return collection.size() > 0 ? CAN_OPEN : CANT_OPEN;
        }
    }

    protected View createNodeView(final Content content, final ViewAxis axis) {
        View treeLeafNode = new LeafNodeView(content, this, axis);
        return treeLeafNode;
    }

    public String getName() {
        return "Collection tree node - closed";
    }
}
// Copyright (c) Naked Objects Group Ltd.
