package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;


/**
 * Specification for a tree node that will display a closed object as a root node or within an object. This
 * will indicate that the created view can be opened if: one of it fields is a collection; it is set up to
 * show objects within objects and one of the fields is an object but it is not a lookup.
 * 
 * @see org.nakedobjects.nos.client.dnd.tree.OpenObjectNodeSpecification for displaying an open collection as
 *      part of an object.
 */
class ClosedObjectNodeSpecification extends NodeSpecification {
    private final boolean showObjectContents;

    public ClosedObjectNodeSpecification(final boolean showObjectContents) {
        this.showObjectContents = showObjectContents;
    }

    public boolean canDisplay(final Content content) {
        return content.isObject() && content.getNaked() != null;
    }

    public int canOpen(final Content content) {
        NakedObject object = ((ObjectContent) content).getObject();
        NakedObjectField[] fields = object.getSpecification().getDynamicallyVisibleFields(object);
        for (int i = 0; i < fields.length; i++) {
            if (fields[i].isCollection()) {
                return CAN_OPEN;
            }

            if (showObjectContents && fields[i].isObject() && !(Features.isBoundedSet(object.getSpecification()))) {
                return CAN_OPEN;
            }
        }
        return CANT_OPEN;
    }

    protected View createNodeView(final Content content, final ViewAxis axis) {
        View treeLeafNode = new LeafNodeView(content, this, axis);
        return treeLeafNode;
    }

    public String getName() {
        return "Object tree node - closed";
    }
}
// Copyright (c) Naked Objects Group Ltd.
