package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nos.client.dnd.CompositeViewBuilder;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;


public abstract class CompositeNodeSpecification extends NodeSpecification implements CompositeViewSpecification, SubviewSpec {
    protected CompositeViewBuilder builder;
    private NodeSpecification collectionLeafNodeSpecification;
    private NodeSpecification objectLeafNodeSpecification;

    public void setCollectionSubNodeSpecification(final NodeSpecification collectionLeafNodeSpecification) {
        this.collectionLeafNodeSpecification = collectionLeafNodeSpecification;
    }

    public void setObjectSubNodeSpecification(final NodeSpecification objectLeafNodeSpecification) {
        this.objectLeafNodeSpecification = objectLeafNodeSpecification;
    }

    protected View createNodeView(final Content content, final ViewAxis axis) {
        return builder.createCompositeView(content, this, axis);
    }

    public View decorateSubview(final View view) {
        return view;
    }

    public CompositeViewBuilder getSubviewBuilder() {
        return builder;
    }

    public View createSubview(final Content content, final ViewAxis axis) {
        if (collectionLeafNodeSpecification.canDisplay(content)) {
            return collectionLeafNodeSpecification.createView(content, axis);
        }

        if (objectLeafNodeSpecification.canDisplay(content)) {
            return objectLeafNodeSpecification.createView(content, axis);
        }

        return null;
    }
}
// Copyright (c) Naked Objects Group Ltd.
