package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;


/**
 * A simple specification that always returns false when asked if it can display any content.
 * 
 * @see #canDisplay(Content)
 */
public class EmptyNodeSpecification extends NodeSpecification {

    public int canOpen(final Content content) {
        return CANT_OPEN;
    }

    protected View createNodeView(final Content content, final ViewAxis axis) {
        return null;
    }

    public boolean canDisplay(final Content content) {
        return false;
    }

    public String getName() {
        return "Empty tree node";
    }
}
// Copyright (c) Naked Objects Group Ltd.
