package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.border.WindowBorder;
import org.nakedobjects.nos.client.dnd.drawing.Size;


/**
 * Specification for a tree browser that displays any object or collection and can display all its contained
 * objects and collection (but not values).
 */
public class FullTreeBrowserSpecification implements ViewSpecification {
    private final OpenCollectionNodeSpecification openCollection;
    private final OpenObjectNodeSpecification openObject;

    public FullTreeBrowserSpecification() {
        ClosedObjectNodeSpecification closedObject = new ClosedObjectNodeSpecification(true);
        ClosedCollectionNodeSpecification closedCollection = new ClosedCollectionNodeSpecification();

        openObject = new OpenObjectNodeSpecification();
        openObject.setCollectionSubNodeSpecification(closedCollection);
        openObject.setObjectSubNodeSpecification(closedObject);
        openObject.setReplacementNodeSpecification(closedObject);

        closedObject.setReplacementNodeSpecification(openObject);

        openCollection = new OpenCollectionNodeSpecification();
        openCollection.setCollectionSubNodeSpecification(closedCollection);
        openCollection.setObjectSubNodeSpecification(closedObject);
        openCollection.setReplacementNodeSpecification(closedCollection);

        closedCollection.setReplacementNodeSpecification(openCollection);
    }

    public boolean canDisplay(final Content content) {
        return openCollection.canDisplay(content) || openObject.canDisplay(content);
    }

    public View createView(final Content content, final ViewAxis unused) {
        TreeBrowserFrame frame = new TreeBrowserFrame(content, this);

        View view = addBorder(frame);
        View rootNode;
        ViewAxis axis = frame;
        if (openCollection.canDisplay(content)) {
            rootNode = openCollection.createView(content, axis);
        } else {
            rootNode = openObject.createView(content, axis);
            frame.setSelectedNode(rootNode);
        }
        View leftPane = rootNode;
        frame.initLeftPane(leftPane);

        Size size = leftPane.getRequiredSize(new Size());
        size.setWidth(220);
        leftPane.setMaximumSize(size);

        return view;
    }

    protected View addBorder(final View frame) {
        return new WindowBorder(frame, false);
    }

    public String getName() {
        return "Long Tree Browser";
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return true;
    }

    public boolean isSubView() {
        return false;
    }
}
// Copyright (c) Naked Objects Group Ltd.
