package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.basic.TableFocusManager;
import org.nakedobjects.nos.client.dnd.border.ScrollBorder;
import org.nakedobjects.nos.client.dnd.builder.CollectionElementBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;
import org.nakedobjects.nos.client.dnd.table.AbstractTableSpecification;
import org.nakedobjects.nos.client.dnd.table.TableHeader;


public class InternalTableSpecification extends AbstractTableSpecification {
    public InternalTableSpecification() {
        builder = new StackLayout(new CollectionElementBuilder(this));
    }

    public View doCreateView(final View view, final Content content, final ViewAxis axis) {
        ScrollBorder scrollingView = new ScrollBorder(view);
        // note - the next call needs to be after the creation of the window border
        // so that it exists when the header is set up
        scrollingView.setTopHeader(new TableHeader(content, view.getViewAxis()));
        scrollingView.setFocusManager(new TableFocusManager(scrollingView));
        return scrollingView;
    }

    public String getName() {
        return "Table";
    }
}
// Copyright (c) Naked Objects Group Ltd.
