package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.builder.CollectionElementBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;


/**
 * Specification for a tree node that will display an open collection as a root node or within an object.
 * 
 * @see org.nakedobjects.nos.client.dnd.tree.ClosedCollectionNodeSpecification for displaying a closed
 *      collection within an object.
 */
public class OpenCollectionNodeSpecification extends CompositeNodeSpecification {
    /**
     * A collection tree can only be displayed for a collection that has elements.
     */
    public boolean canDisplay(final Content content) {
        return content.isCollection() && ((CollectionContent) content).getCollection().size() > 0;
    }

    public OpenCollectionNodeSpecification() {
        builder = new StackLayout(new CollectionElementBuilder(this));
    }

    public boolean isOpen() {
        return true;
    }

    public int canOpen(final Content content) {
        return CAN_OPEN;
    }

    public String getName() {
        return "Collection tree node - open";
    }
}
// Copyright (c) Naked Objects Group Ltd.
