package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.builder.ObjectFieldBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;


/**
 * Specification for a tree node that will display an open object as a root node or within an object.
 * 
 * @see org.nakedobjects.nos.client.dnd.tree.ClosedObjectNodeSpecification for displaying a closed collection
 *      within an object.
 */
public class OpenObjectNodeSpecification extends CompositeNodeSpecification {

    public OpenObjectNodeSpecification() {
        builder = new StackLayout(new ObjectFieldBuilder(this));
    }

    /**
     * This is only used to control root nodes. Therefore a object tree can only be displayed for an object
     * with fields that are collections.
     */
    public boolean canDisplay(final Content content) {
        if (content.isObject() && content.getNaked() != null) {
            NakedObject object = (NakedObject) content.getNaked();
            NakedObjectField[] fields = object.getSpecification().getDynamicallyVisibleFields(object);
            for (int i = 0; i < fields.length; i++) {
                if (fields[i].isCollection()) {
                    return true;
                }
            }
        }

        return false;
    }

    public int canOpen(final Content content) {
        return CAN_OPEN;
    }

    public boolean isOpen() {
        return true;
    }

    public String getName() {
        return "Object tree node - open";
    }
}
// Copyright (c) Naked Objects Group Ltd.
