package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.CollectionElementBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;


class SimpleListSpecification extends AbstractCompositeViewSpecification implements SubviewSpec {

    public SimpleListSpecification() {
        builder = new StackLayout(new CollectionElementBuilder(this));
    }

    // TODO the rest of this is the same as ListSpecificatio - see InternalListSpecificat as well
    public View createSubview(final Content content, final ViewAxis axis) {
        ViewSpecification specification = Toolkit.getViewFactory().getIconizedSubViewSpecification((ObjectContent) content);
        return specification.createView(content, axis);
    }

    public String getName() {
        return "Standard List";
    }

    public boolean canDisplay(final Content content) {
        return content.isCollection();
    }
}
// Copyright (c) Naked Objects Group Ltd.
