package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.basic.ResizeBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.DrawingUtil;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.util.Properties;


public class TreeBrowserResizeBorder extends ResizeBorder {
    public static final int BORDER_WIDTH = NakedObjectsContext.getConfiguration().getInteger(Properties.PROPERTY_BASE + "tree-resize-border", 7);

    public TreeBrowserResizeBorder(final View view) {
        super(view, RIGHT, BORDER_WIDTH, 2);
    }

    protected void drawResizeBorder(final Canvas canvas, final Size size) {
        int x = getSize().getWidth() - BORDER_WIDTH;
        final int height = getSize().getHeight() - 1;
        int h1 = 30;
        int h2 = 10;
        if (height < h1 + h2 * 2) {
            h1 = Math.min(0, height - h2 * 2);
        } else {
            h2 = (height - h1) / 2;
        }
        
        boolean hasFocus = getParent().containsFocus();
        Color borderColor = hasFocus ? Toolkit.getColor("primary3") : Toolkit.getColor("secondary3");
        canvas.drawSolidRectangle(x, 0, BORDER_WIDTH, height, borderColor);
        
        canvas.drawRectangle(x, -1, BORDER_WIDTH, height + 2, Toolkit.getColor("secondary2"));
        
        Color color = hasFocus ? Toolkit.getColor("primary2") : Toolkit.getColor("secondary2");
        DrawingUtil.drawHatching(canvas, x + 1,  h2, BORDER_WIDTH - 2, h1, color, Toolkit.getColor("white"));
    }

}
// Copyright (c) Naked Objects Group Ltd.
