package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.basic.NullFocusManager;
import org.nakedobjects.nos.client.dnd.border.WindowBorder;
import org.nakedobjects.nos.client.dnd.drawing.Size;


/**
 * Specification for a tree browser frame with a tree displaying only collections and objects containing
 * collections.
 */
public class TreeBrowserSpecification implements ViewSpecification {
    private final OpenCollectionNodeSpecification openCollection;
    private final OpenObjectNodeSpecification openObject;

    public TreeBrowserSpecification() {
        ClosedObjectNodeSpecification closedObject = new ClosedObjectNodeSpecification(false);
        NodeSpecification closedCollection = new ClosedCollectionNodeSpecification();
        EmptyNodeSpecification noNode = new EmptyNodeSpecification();

        openCollection = new OpenCollectionNodeSpecification();
        openCollection.setCollectionSubNodeSpecification(noNode);
        openCollection.setObjectSubNodeSpecification(closedObject);
        openCollection.setReplacementNodeSpecification(closedCollection);

        openObject = new OpenObjectNodeSpecification();
        openObject.setCollectionSubNodeSpecification(closedCollection);
        openObject.setObjectSubNodeSpecification(noNode);
        openObject.setReplacementNodeSpecification(closedObject);

        closedObject.setReplacementNodeSpecification(openObject);

        closedCollection.setReplacementNodeSpecification(openCollection);
    }

    protected View addBorder(final View frame) {
        return new WindowBorder(frame, false);
    }

    public boolean canDisplay(final Content content) {
        return openCollection.canDisplay(content) || openObject.canDisplay(content);
    }

    public View createView(final Content content, final ViewAxis unused) {
        TreeBrowserFrame frame = new TreeBrowserFrame(content, this);

        View view = addBorder(frame);
        View rootNode;
        ViewAxis axis = frame;
        if (openCollection.canDisplay(content)) {
            rootNode = openCollection.createView(content, axis);
        } else {
            rootNode = openObject.createView(content, axis);
            frame.setSelectedNode(rootNode);
        }
        View leftPane = rootNode;
        frame.initLeftPane(leftPane);

        Size size = leftPane.getRequiredSize(new Size());
        size.setWidth(220);
        leftPane.setMaximumSize(size);

        view.setFocusManager(new NullFocusManager());

        return view;
    }

    public String getName() {
        return "Short Tree Browser";
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return true;
    }

    public boolean isSubView() {
        return false;
    }
}
// Copyright (c) Naked Objects Group Ltd.
