package org.nakedobjects.nos.client.dnd.view.calendar;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class CalendarBorder extends AbstractBorder {
    private static final int HEIGHT = 20;
    private final CalendarBorderTab[] tabs;
    private int over;
    private int selected;

    protected CalendarBorder(CalendarTemplate view, CalendarBorderTab[] tabs) {
        super(view);
        this.tabs = tabs;
        top = HEIGHT;
    }
    
    public void draw(Canvas canvas) {
        int width = tabWidth();
        for (int i = 0; i < tabs.length; i++) {
            Canvas tabcanvas = canvas.createSubcanvas(i * width, 0, width, HEIGHT);
            if (i == selected) {
                tabcanvas.drawSolidRectangle(0, 0, width + 1, HEIGHT + 5, Toolkit.getColor("primary3"));                
            } else if(i == over) {
                tabcanvas.drawSolidRectangle(0, 0, width + 1, HEIGHT + 5, Toolkit.getColor("secondary3"));                
            }
            tabs[i].draw(tabcanvas, width);
            tabcanvas.drawRoundedRectangle(0, 0, width + 1, HEIGHT + 5, 5, 5, Toolkit.getColor("black"));
        }
        super.draw(canvas);
    }
    
    public void firstClick(Click click) {
        if (overContent(click.getLocation())) {
            super.firstClick(click);
        } else {
            int x = click.getLocation().getX();
            int i = overTab(x);
            click.subtract(i * tabWidth(), 0);
            if (tabs[i].select(click, (CalendarTemplate) getView())) {
                selected = i;
            }
        }
    }

    private int overTab(int x) {
        int width = tabWidth();
        int i = x / width;
        return i;
    }

    private int tabWidth() {
        return getSize().getWidth() / tabs.length;
    }
    
    public void mouseMoved(Location at) {
        if (overContent(at))  {
            super.mouseMoved(at);
            over = -1;
            markDamaged();
        } else {
            over = overTab(at.getX());
            markDamaged();
        }
    }

    public void exited() {
        super.exited();
        over = -1;
        markDamaged();
    }
}


// Copyright (c) Naked Objects Group Ltd.
