package org.nakedobjects.nos.client.dnd.view.calendar;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.value.DateValue;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nos.client.dnd.CompositeViewBuilder;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.builder.AbstractBuilderDecorator;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public class CalendarLayout extends AbstractBuilderDecorator {

    public CalendarLayout(CompositeViewBuilder design) {
        super(design);
    }
    
    public Size getRequiredSize(View view) {
        CalendarAxis calendarAxis = (CalendarAxis) view.getViewAxis();
        CalendarDisplay calendarDisplay = calendarAxis.getCalendarDisplay();
        return calendarDisplay.getRequiredSize();
    }

    public void layout(View view, Size maximumSize) {
        CalendarAxis calendarAxis = ((CalendarAxis) view.getViewAxis());
        CalendarDisplay calendarDisplay = calendarAxis.getCalendarDisplay();
        Size size = view.getSize();
        size.contract(view.getPadding());
        
        int width;
        int height;
        Size blockSize = calendarDisplay.getBlockSize(size);
        width = blockSize.getWidth();
        height =blockSize.getHeight();
        
        View subviews[] = view.getSubviews();
        for (int i = 0; i < subviews.length; i++) {
            View v = subviews[i];
            
            DateValue date = findDate(v);
            if(date == null) {
                continue;
            }
            
            calendarDisplay.layoutDate(v, date.dateValue(), width, height);
        }

    }

      private DateValue findDate(View view) {
        Content c = view.getContent();
        Naked adapter = c.getNaked();
        NakedObjectSpecification spec = adapter.getSpecification();
        NakedObjectField[] fields = spec.getFields();
        DateValue date = null;
        for (int j = 0; j < fields.length; j++) {
            Naked field = fields[j].get((NakedObject) adapter);
            if (field instanceof DateValue) {
                return (DateValue) field;
            }
            /*
            if(fields[j].getSpecification() == NakedObjectsContext.getReflector().loadSpecification(DateValue.class)) {
                date = (DateValue) fields[j].get((NakedObject) adapter).getObject();
                break;
            }
            */
        }
        return date;
    }
}


// Copyright (c) Naked Objects Group Ltd.
