package org.nakedobjects.nos.client.dnd.view.calendar;

import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.border.ObjectBorder;
import org.nakedobjects.nos.client.dnd.border.WindowBorder;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.CollectionElementBuilder;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.Icon;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;


public class CalendarSpecification extends AbstractCompositeViewSpecification implements SubviewSpec {

    public CalendarSpecification() {
        builder = new CalendarLayout(new CollectionElementBuilder(this));
    }

    public boolean canDisplay(Content content) {
        return content instanceof CollectionContent;
    }

    public View createView(Content content, ViewAxis axis) {
        ViewAxis ax = new CalendarAxis();
        CalendarDisplay monthDisplay = new MonthDisplay();
        CalendarDisplay weekDisplay = new WeekDisplay();
        CalendarTemplate calendarTemplate = new CalendarTemplate(super.createView(content, ax), monthDisplay);
        CalendarBorderTab[] tabs = new CalendarBorderTab[] { new NamedCalendarBorderTab("Month", monthDisplay),
                new NamedCalendarBorderTab("Week", weekDisplay), new NamedCalendarBorderTab("Day", null) };
        CalendarBorder calendarBorder = new CalendarBorder(calendarTemplate, tabs);
        WindowBorder newView = new WindowBorder(calendarBorder, true);
        return newView;
    }

    public String getName() {
        return "Calendar";
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return true;
    }

    public boolean isSubView() {
        return false;
    }

    public View createSubview(final Content content, final ViewAxis axis) {
        // Specification spec = new FallbackView.Specification();
        // return new PanelBorder(spec.createView(content, axis));

        Icon icon = new Icon(content, this, axis);

        icon.setTitle(new ObjectTitleText(icon, Toolkit.getText("normal")));
        icon.setSelectedIcon(new IconGraphic(icon, 24));
        icon.setVertical(true);

        return new ObjectBorder(icon);

    }
}

// Copyright (c) Naked Objects Group Ltd.
