package org.nakedobjects.nos.client.dnd.view.calendar;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractViewDecorator;


public class CalendarTemplate extends AbstractViewDecorator {
    private CalendarDisplay calendarDisplay;

    protected CalendarTemplate(View wrappedView, CalendarDisplay initialCalendarDisplay) {
        super(wrappedView);
        setCalendarDisplay(initialCalendarDisplay);
    }

    public void draw(Canvas canvas) {
        calendarDisplay.draw(canvas, getSize());
        super.draw(canvas);
    }

    public void drop(ContentDrag drag) {
        if (calendarDisplay.drop(drag, getSize())) {
            invalidateLayout();
        } else {
            super.drop(drag);
        }
    }

    /*
     * public void drag(InternalDrag drag) { int day = dayAtPointerForMonthView(drag); if(day != overDay) {
     * overDay = day; markDamaged(); }
     * 
     * super.drag(drag); }
     * 
     * public void dragCancel(InternalDrag drag) { super.dragCancel(drag); overDay = -1; }
     * 
     * public void dragTo(InternalDrag drag) { super.dragTo(drag); overDay = -1; }
     */

    public void firstClick(Click click) {
        calendarDisplay.firstClick(click, getSize());
        // super.firstClick(click);
    }

    public void setCalendarDisplay(CalendarDisplay calendarDisplay) {
        this.calendarDisplay = calendarDisplay;
        ((CalendarAxis) wrappedView.getViewAxis()).setCalendarDisplay(calendarDisplay);

    }
}

// Copyright (c) Naked Objects Group Ltd.
