package org.nakedobjects.nos.client.dnd.view.calendar;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;

import java.util.Calendar;
import java.util.Date;


public class MonthDisplay implements CalendarDisplay {
    private int overDay;
    private Calendar focusDate;

    public MonthDisplay() {
        focusDate = Calendar.getInstance();
    }
    
    public void draw(Canvas canvas, Size size) {
        monthGrid(canvas, size);
    }

    public boolean drop(ContentDrag drag, Size size) {
        int day = dayAtPointerForMonthView(drag, size);

        Naked adapter = drag.getSourceContent().getNaked();
        // booking.setDate(new Date(2006, 11, day));

        return day > 0;
    }

    private int dayAtPointerForMonthView(ContentDrag drag, Size size) {
        int width = size.getWidth() / 7;
        int height = size.getHeight() / 5;

        Location pointer = drag.getTargetLocation();
        int column = pointer.getX() / width;
        int row = pointer.getY() / height;

        int day = row * 7 + column + 1;

        System.out.println(pointer + " " + day);
        return day;
    }

    private void monthGrid(Canvas canvas, Size size) {
        int width = size.getWidth() / 7;
        int height = size.getHeight() / 5;

        canvas.drawSolidRectangle(0, 0, width * 2, height * 5, CalendarConstants.weekendColor);
        int day = 1 - getMonthOffSet();
        int y = 4;
        for (int rows = 0; rows < 5; rows++) {
            canvas.drawLine(0, rows * height, width * 7, rows * height, CalendarConstants.lineColor);
            int x = 4;
            for (int cols = 0; cols < 7; cols++) {
                if (day > 0) {
                    canvas.drawText("" + day, x, y + CalendarConstants.style.getAscent(), CalendarConstants.textColor,
                            CalendarConstants.style);
                }
                day++;
                x += width;
            }
            y += height;
        }
        for (int cols = 0; cols < 7; cols++) {
            canvas.drawLine(cols * width, 0, cols * width, height * 5, CalendarConstants.lineColor);
        }

        if (overDay > 0) {
            y = overDay / 7 * height;
            int x = (overDay % 7) * width;
            canvas.drawRectangle(x, y, width, height, Toolkit.getColor("primary1"));
        }
    }

    public void firstClick(Click click, Size size) {
        if (new Bounds(0, 0, 10, 10).contains(click.getLocation())) {
            focusDate.add(Calendar.MONTH, -1);
        } else if (new Bounds(size.getWidth() - 10, size.getHeight() - 10, 10, 10).contains(click.getLocation())) {
            focusDate.add(Calendar.MONTH, 1);
        }
    }

    public Size getBlockSize(Size size) {
        return new Size(size.getWidth() / 7, size.getHeight() / 5);
    }

    public void layoutDate(View v, Date date, int width, int height) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(Calendar.DAY_OF_MONTH);

        int col = (day - 1) % 7;
        int row = (day - 1) / 7;

        int x = width * col + 20;
        int y = height * row + 5;
        v.layout(new Size(width - 19, height - 6));
        v.setLocation(new Location(x, y));
        v.setSize(new Size(width - 19, height - 6));
    }

    private int getMonthOffSet() {
        Calendar c = Calendar.getInstance();
        c.set(focusDate.get(Calendar.YEAR), focusDate.get(Calendar.MONTH), 1);
        int offset = c.get(Calendar.DAY_OF_WEEK);
        return offset;
    }

    public Size getRequiredSize() {
        return new Size(80 * 7, 250);
    }

}

// Copyright (c) Naked Objects Group Ltd.
