package org.nakedobjects.nos.client.dnd.view.dialog;

import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.ButtonBorder;
import org.nakedobjects.nos.client.dnd.focus.AbstractFocusManager;


public class ActionDialogFocusManager extends AbstractFocusManager {
    private final ButtonBorder buttonBorder;

    public ActionDialogFocusManager(final ButtonBorder buttonBorder) {
        super(buttonBorder.getView());
        this.buttonBorder = buttonBorder;

    }

    protected View[] getChildViews() {
        View[] subviews = container.getSubviews();
        View[] buttons = buttonBorder.getButtons();

        View[] views = new View[subviews.length + buttons.length];
        System.arraycopy(subviews, 0, views, 0, subviews.length);
        System.arraycopy(buttons, 0, views, subviews.length, buttons.length);
        return views;
    }
}
// Copyright (c) Naked Objects Group Ltd.
