package org.nakedobjects.nos.client.dnd.view.dialog;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.ActionContent;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.ButtonAction;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.ObjectParameter;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ValueParameter;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewFactory;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractButtonAction;
import org.nakedobjects.nos.client.dnd.action.CancelAction;
import org.nakedobjects.nos.client.dnd.border.ButtonBorder;
import org.nakedobjects.nos.client.dnd.border.DialogBorder;
import org.nakedobjects.nos.client.dnd.border.DroppableLabelBorder;
import org.nakedobjects.nos.client.dnd.border.IconBorder;
import org.nakedobjects.nos.client.dnd.border.LabelBorder;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class ActionDialogSpecification extends AbstractCompositeViewSpecification {
    private static final Logger LOG = Logger.getLogger(ActionDialogSpecification.class);
    
    private static class DialogFormSubviews implements SubviewSpec {
        
        public View createSubview(final Content content, final ViewAxis axis) {
            if (content instanceof ValueParameter) {
                ViewFactory factory = Toolkit.getViewFactory();
                ViewSpecification specification = factory.getValueFieldSpecification((ValueContent) content);
                return specification.createView(content, axis);
            } else if (content instanceof ObjectParameter) {
                ViewFactory factory = Toolkit.getViewFactory();
                ViewSpecification specification = factory.getIconizedSubViewSpecification(content);
                return specification.createView(content, axis);
            }

            return null;
        }

        public View decorateSubview(final View fieldView) {
            if (fieldView.getContent() instanceof ObjectParameter) {
                return DroppableLabelBorder.createObjectParameterLabelBorder(fieldView);
            } else {
                return LabelBorder.createValueParameterLabelBorder(fieldView);
            }
        }
    }

    private static class ExecuteAction extends AbstractButtonAction {
        public ExecuteAction() {
            this("Apply");
        }

        public ExecuteAction(final String name) {
            super(name, true);
        }

        public Consent disabled(final View view) {
            View[] subviews = view.getSubviews();
            StringBuffer missingFields = new StringBuffer();
            StringBuffer invalidFields = new StringBuffer();
            for (int i = 0; i < subviews.length; i++) {
                View field = subviews[i];
                ParameterContent content = ((ParameterContent) field.getContent());
                if (content.isRequired()
                        && (content.getNaked() == null || (content.getNaked() instanceof NakedValue && ((NakedValue) content
                                .getNaked()).isEmpty()))) {
                    String parameterName = content.getParameterName();
                    if (missingFields.length() > 0) {
                        missingFields.append(", ");
                    }
                    missingFields.append(parameterName);

                } else if (field.getState().isInvalid()) {
                    String parameterName = content.getParameterName();
                    if (invalidFields.length() > 0) {
                        invalidFields.append(", ");
                    }
                    invalidFields.append(parameterName);
                }
            }
            if (missingFields.length() > 0) {
                return new Veto("Fields needed: " + missingFields);
            }
            if (invalidFields.length() > 0) {
                return new Veto("Invalid fields: " + invalidFields);
            }

            ActionContent actionContent = ((ActionContent) view.getContent());
            return actionContent.disabled();
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            BackgroundTask task = new BackgroundTask() {
                public void execute() {
                    ActionContent actionContent = ((ActionContent) view.getContent());
                    Naked result = actionContent.execute();
                    LOG.debug("action invoked with result " + result);
                    if (result != null) {
                        Location dialogLocation = view.getAbsoluteLocation();
                        move(dialogLocation);
                        if (result instanceof NakedCollection) {
                            NakedCollection collection = ((NakedCollection) result);
                            if (collection.size() == 1) {
                                result = collection.firstElement();
                            }
                        }
                        View newView = workspace.addOpenViewFor(result, dialogLocation);
                        view.getViewManager().setKeyboardFocus(newView);
                    }
                    view.getViewManager().disposeUnneededViews();
                    view.getFeedbackManager().showMessagesAndWarnings();
                }

                public String getName() {
                    return ((ActionContent) view.getContent()).getActionName();
                }

                public String getDescription() {
                    return "Running action " + getName() + " on  " + view.getContent().getNaked();
                }
            };
            LOG.debug("  ... created task " + task);

            BackgroundThread.run(view, task);
        }

        protected void move(final Location at) {
            at.move(30, 60);
        }
    }

    private static class ExecuteAndCloseAction extends ExecuteAction {
        public ExecuteAndCloseAction() {
            super("OK");
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            LOG.debug("executing action " + this);
            view.dispose();
            LOG.debug("  ... disposed view, now executing");
            super.execute(workspace, view, at);
            view.getViewManager().setKeyboardFocus(workspace);
            // view.getViewManager().clearKeyboardFocus();
        }

        protected void move(final Location at) {}
    }

    public ActionDialogSpecification() {
        builder = new StackLayout(new ActionFieldBuilder(new DialogFormSubviews()));
    }

    public boolean canDisplay(final Content content) {
        return content instanceof ActionContent;
    }

    public View createView(final Content content, final ViewAxis axis) {
        // TODO reintroduce the 'Apply' notion, but under control from the method declaration
        ButtonAction[] actions = new ButtonAction[] { new ExecuteAndCloseAction(), new CancelAction() };
        View container = super.createView(content, new LabelAxis());
        ButtonBorder buttonBorder = new ButtonBorder(actions, new IconBorder(container));
        DialogBorder dialog = new DialogBorder(buttonBorder, false);
        dialog.setFocusManager(new ActionDialogFocusManager(buttonBorder));
        return dialog;
    }

    public String getName() {
        return "Action Dialog";
    }

}
// Copyright (c) Naked Objects Group Ltd.
