package org.nakedobjects.nos.client.dnd.view.dialog;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nos.client.dnd.ActionContent;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectParameter;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.ValueParameter;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.builder.AbstractViewBuilder;
import org.nakedobjects.nos.client.dnd.content.ObjectParameterImpl;
import org.nakedobjects.nos.client.dnd.view.simple.CompositeView;


public class ActionFieldBuilder extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(ActionFieldBuilder.class);
    private SubviewSpec subviewDesign;

    public ActionFieldBuilder(final SubviewSpec subviewDesign) {
        this.subviewDesign = subviewDesign;
    }

    public void build(final View view) {
        Assert.assertEquals(view.getView(), view);

        ActionContent actionContent = ((ActionContent) view.getContent());
        if (view.getSubviews().length == 0) {
            newBuild(view, actionContent);
        } else {
            updateBuild(view, actionContent);
        }

    }

    public View createCompositeView(final Content content, final CompositeViewSpecification specification, final ViewAxis axis) {
        return new CompositeView(content, specification, axis);
    }

    private View createFieldView(final View view, final ParameterContent parameter) {
        View fieldView = subviewDesign.createSubview(parameter, view.getViewAxis());
        if (fieldView == null) {
            throw new NakedObjectRuntimeException("All parameters must be shown");
        }
        return fieldView;
    }
    
    public View decorateSubview(View subview) {
        return subviewDesign.decorateSubview(subview);
    }

    private void newBuild(final View view, final ActionContent actionContent) {
        LOG.debug("build new view " + view + " for " + actionContent);
        int noParameters = actionContent.getNoParameters();
        View focusOn = null;
        for (int f = 0; f < noParameters; f++) {
            ParameterContent parameter = actionContent.getParameterContent(f);
            View fieldView = createFieldView(view, parameter);
            View decoratedSubview = decorateSubview(fieldView);
            view.addView(decoratedSubview);

            // set focus to first value field
            if (focusOn == null && parameter instanceof ValueParameter && fieldView.canFocus()) {
                focusOn = decoratedSubview;
            }
        }

        if (focusOn != null) {
            view.getViewManager().setKeyboardFocus(focusOn);
        }
    }

    private void updateBuild(final View view, final ActionContent actionContent) {
        LOG.debug("rebuild view " + view + " for " + actionContent);
        View[] subviews = view.getSubviews();

        for (int i = 0; i < subviews.length; i++) {
            View subview = subviews[i];
            Content content = subview.getContent();

            Naked subviewsObject = subview.getContent().getNaked();
            Naked invocationsObject = ((ActionContent) view.getContent()).getParameterObject(i);

            if (content instanceof ObjectParameter) {
                if (subviewsObject != invocationsObject) {
                    ObjectParameter parameter = new ObjectParameterImpl((ObjectParameterImpl) content, (NakedObject) invocationsObject);
                    View fieldView = createFieldView(view, parameter);
                    view.replaceView(subview, decorateSubview(fieldView));
                }
            } else {
                subview.refresh();
            }
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
