package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.adapter.value.BooleanValue;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.AbstractFieldSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Shape;
import org.nakedobjects.nos.client.dnd.drawing.Size;


/*
 * TODO this class does not set the underlying business object  via its boolean adapter.  Need
 * to create an content type for flags.
 */
public class CheckboxField extends AbstractField {
    private static final int size = Toolkit.getText("normal").getTextHeight();

    public static class Specification extends AbstractFieldSpecification {
        public boolean canDisplay(final Content content) {
            return content.isValue() && content.getNaked() instanceof BooleanValue;
        }

        public View createView(final Content content, final ViewAxis axis) {
            return new CheckboxField(content, this, axis);
        }

        public String getName() {
            return "Checkbox";
        }
    }

    public CheckboxField(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(final Canvas canvas) {
        Color color;
        color = getIdentified() ? Toolkit.getColor("secondary2") : null;
        color = hasFocus() ? Toolkit.getColor("identified") : color;

        int top = VPADDING;
        int left = HPADDING;
        if(color != null) {
            canvas.drawRectangle(left - 2, top - 2, size + 4, size + 4, color);
        }

        color = Toolkit.getColor("black");
        canvas.drawRectangle(left, top, size, size , color);
        if (isSet()) {
            
            Shape tick = new Shape(0, 6);
         //   tick.addVertex(12, 8);
            tick.addVertex(4, 12);
          //  tick.addVertex(6, 8);
          //  tick.addVertex(8, 5);
            tick.addVertex(12, 0);
           // tick.addVertex(8, 4);
           // tick.addVertex(4, 7);
            tick.addVertex(4, 8);

            canvas.drawSolidShape(tick, 3, 3, color);
            
            /*
            left += 2;
            top += 2;
            int bottom = size - 1;
            int right = size - 2;
            canvas.drawLine(left, top, right, bottom, color);
            canvas.drawLine(left + 1, top, right + 1, bottom, color);
            canvas.drawLine(right, top, left, bottom, color);
            canvas.drawLine(right + 1, top, left + 1, bottom, color);
            */
        }
    }

    public void firstClick(final Click click) {
        toggle();
    }

    public void keyTyped(char keyCode) {
        if(keyCode == ' ') {
            toggle();
        } else {
            super.keyTyped(keyCode);
        }
    }
    
    private void toggle() {
        if (canChangeValue().isAllowed()) {
            initiateSave();
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("normal").getAscent();
    }

    public Size getMaximumSize() {
        return new Size(HPADDING + size + HPADDING, VPADDING + size + VPADDING);
    }

    private boolean isSet() {
        BooleanValue value = (BooleanValue) getContent().getNaked();
        return value.isSet();
    }

    protected void save() {
        // TODO canChangeValue does not work for this type - need to fix
        // if (canChangeValue()) {
        BooleanValue value = (BooleanValue) getContent().getNaked();
        value.toggle();
        markDamaged();
        ((ValueContent) getContent()).entryComplete();
        getParent().invalidateContent();
    }
}
// Copyright (c) Naked Objects Group Ltd.
