package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class ClearValueOption extends AbstractValueOption {
    private final AbstractField field;

    public ClearValueOption(final AbstractField field) {
        super("Clear");
        this.field = field;
    }

    public String getDescription(final View view) {
        return "Clear field";
    }

    public Consent disabled(final View view) {
        NakedValue value = getValue(view);
        ValueContent field = (ValueContent) view.getContent();
        Consent changable = view.canChangeValue();
        if (changable.isVetoed()) {
            return changable;
        } else if (!field.canClear()) {
            return new Veto("Can't clear " + value.getSpecification().getShortName() + " values");
        } else if (isEmpty(view)) {
            return new Veto("Field is already empty");
        } else {
            return new Allow("Clear value " + value.titleString());
        }
    }

    public void execute(final Workspace frame, final View view, final Location at) {
        field.clear();
    }

    public String toString() {
        return "ClearValueOption";
    }
}
// Copyright (c) Naked Objects Group Ltd.
