package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.value.ColorValue;
import org.nakedobjects.nof.core.util.NotImplementedException;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.border.DisposeOverlay;
import org.nakedobjects.nos.client.dnd.builder.AbstractFieldSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class ColorField extends AbstractField {
    public static class Specification extends AbstractFieldSpecification {

        public boolean canDisplay(final Content content) {
            return content.isValue() && content.getNaked() instanceof ColorValue;
        }

        public View createView(final Content content, final ViewAxis axis) {
            return new ColorField(content, this, axis);
        }

        public String getName() {
            return "Color";
        }
    }

    private int color;

    public ColorField(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(final Canvas canvas) {
        Color color;

        if (hasFocus()) {
            color = Toolkit.getColor("primary1");
        } else if (getParent().getState().isObjectIdentified()) {
            color = Toolkit.getColor("identified");
        } else if (getParent().getState().isRootViewIdentified()) {
            color = Toolkit.getColor("primary2");
        } else {
            color = Toolkit.getColor("secondary1");
        }

        int top = 0;
        int left = 0;

        Size size = getSize();
        int w = size.getWidth() - 1;
        int h = size.getHeight() - 1;
        canvas.drawRectangle(left, top, w, h, color);
        left++;
        top++;
        w -= 1;
        h -= 1;
        canvas.drawSolidRectangle(left, top, w, h, Toolkit.getColor(getColor()));
    }

    public void firstClick(final Click click) {
        if (((ValueContent) getContent()).isEditable().isAllowed()) {
            View overlay = new DisposeOverlay(new ColorFieldOverlay(this));
            Location location = this.getAbsoluteLocation();
            // Location location = click.getLocationWithinViewer();
            // TODO offset by constant amount
            // location.move(10, 10);
            overlay.setLocation(location);
            // overlay.setSize(overlay.getRequiredSize(new Size()));
            // overlay.markDamaged();
            getViewManager().setOverlayView(overlay);
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("normal").getAscent();
    }

    int getColor() {
        ValueContent content = ((ValueContent) getContent());
        ColorValue value = (ColorValue) content.getObject();
        return value.color();
    }

    public Size getMaximumSize() {
        return new Size(45, 15);
    }

    protected void save() {
        try {
            parseEntry("" + color);
        } catch (InvalidEntryException e) {
            throw new NotImplementedException();
        }
    }

    /*
     * public void refresh() { ValueField content = ((ValueField) getContent()); Value field =
     * content.getValueField();
     * 
     * if (field.isDerived()) { content.getValue().copyObject((Logical) field.get( ((ObjectContent)
     * getParent().getContent()).getObject())); } }
     */
    void setColor(int color) {
        this.color = color;
        initiateSave();
    }
}
// Copyright (c) Naked Objects Group Ltd.
