package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class CopyValueOption extends AbstractValueOption {
    private final AbstractField field;

    public CopyValueOption(final AbstractField field) {
        super("Copy");
        this.field = field;
    }

    public Consent disabled(final View view) {
        if (isEmpty(view)) {
            return new Veto("Field is empty");
        } else {
            return new Allow("Copy value '" + field.getSelectedText() + "' to clipboard");
        }
    }

    public void execute(final Workspace frame, final View view, final Location at) {
        field.copyToClipboard();
    }

    public String toString() {
        return "CopyValueOption";
    }
}
// Copyright (c) Naked Objects Group Ltd.
