package org.nakedobjects.nos.client.dnd.view.field;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.value.ImageValue;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.ValueField;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.builder.AbstractFieldSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.image.AwtImage;


public class ImageField extends AbstractField {
    public static class Specification extends AbstractFieldSpecification {
        public boolean canDisplay(final Content content) {
            return content.isValue() && content.getNaked() instanceof ImageValue;
        }

        public View createView(final Content content, final ViewAxis axis) {
            return new ImageField(content, this, axis);
        }

        public String getName() {
            return "Image";
        }
    }

    private static final Logger LOG = Logger.getLogger(ImageField.class);
    private static final MediaTracker mt = new MediaTracker(new java.awt.Canvas());

    public ImageField(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }

    public boolean canFocus() {
        return true;
    }

    public void contentMenuOptions(final UserActionSet options) {
        super.contentMenuOptions(options);

        options.add(new AbstractUserAction("Load image from file...") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                String file = getViewManager().selectFilePath("Load image", ".");
                loadImageFromFile(file);
            }

        });
    }

    private void copy() {}

    public void draw(final Canvas canvas) {
        Color color;

        if (hasFocus()) {
            color = Toolkit.getColor("primary1");
        } else if (getParent().getState().isObjectIdentified()) {
            color = Toolkit.getColor("identified");
        } else if (getParent().getState().isRootViewIdentified()) {
            color = Toolkit.getColor("primary2");
        } else {
            color = Toolkit.getColor("secondary1");
        }

        int top = 0;
        int left = 0;

        Size size = getSize();
        int w = size.getWidth() - 1;
        int h = size.getHeight() - 1;
        canvas.drawRectangle(left, top, w, h, color);
        left++;
        top++;
        w -= 1;
        h -= 1;

        ImageValue value = (ImageValue) getContent().getNaked();
        java.awt.Image image = value.getImage();
        if (image != null) {
            Size imageSize = new Size(value.getWidth(), value.getHeight());
            if (imageSize.getWidth() <= w && imageSize.getHeight() <= h) {
                canvas.drawImage(new AwtImage(image), left, top);
            } else {
                canvas.drawImage(new AwtImage(image), left, top, w, h);
            }
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("normal").getAscent();
    }

    public Size getMaximumSize() {
        Size size = new Size(60, 60);
        return size;
    }

    public Size getRequiredSize(Size maximumSize) {
        ImageValue value = (ImageValue) getContent().getNaked();
        if (value.isEmpty()) {
            return super.getRequiredSize(maximumSize);
        } else {
            int width = Math.min(120, Math.max(32, value.getWidth()));
            int height = Math.min(120, Math.max(32, value.getHeight()));
            return new Size(width, height);
        }
    }

    public void keyPressed(final KeyboardAction key) {
        if (canChangeValue().isVetoed()) {
            return;
        }

        int keyCode = key.getKeyCode();
        if (keyCode == KeyEvent.VK_CONTROL || keyCode == KeyEvent.VK_SHIFT || keyCode == KeyEvent.VK_ALT) {
            return;
        }

        int modifiers = key.getModifiers();
        final boolean ctrl = (modifiers & InputEvent.CTRL_MASK) > 0;

        switch (keyCode) {
        case KeyEvent.VK_V:
            if (ctrl) {
                key.consume();
                pasteFromClipboard();
            }
            break;
        case KeyEvent.VK_C:
            if (ctrl) {
                key.consume();
                copy();
            }
            break;
        }
    }

    private void loadImage(Image image) {
        mt.addImage(image, 1);
        try {
            mt.waitForAll();
        } catch (InterruptedException e) {
            throw new NakedObjectRuntimeException(e);
        }

        ImageValue value = (ImageValue) getContent().getNaked();
        value.setImage(image);
        ((ValueField) getContent()).entryComplete();
        invalidateLayout();
    }

    private void loadImageFromURL(final String filename) {
        try {
            final URL url = new URL("file://" + filename);
            Image image = java.awt.Toolkit.getDefaultToolkit().getImage(url);
            loadImage(image);
        } catch (MalformedURLException e) {
            throw new NakedObjectRuntimeException("Failed to load image from " + filename);
        }
    }

    private void loadImageFromFile(final String filename) {
        final Image image = java.awt.Toolkit.getDefaultToolkit().getImage(filename);
        loadImage(image);
    }

    void pasteFromClipboard() {
        Clipboard cb = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = cb.getContents(this);

        try {
            if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                // treat a string as a file
                String filename = (String) content.getTransferData(DataFlavor.stringFlavor);
                LOG.debug("pasted image from " + filename);
                loadImageFromFile("file://" + filename);

            } else {
                LOG.info("unsupported paste operation " + content);

                // note java does not support transferring images from the clipboard
                // although it has an image flavor for it !!?
                /*
                 * DataFlavor[] transferDataFlavors = content.getTransferDataFlavors(); for (int i = 0; i <
                 * transferDataFlavors.length; i++) { LOG.debug("data transfer as " +
                 * transferDataFlavors[i].getMimeType()); }
                 * 
                 * Image image = (Image) content.getTransferData(DataFlavor.imageFlavor); LOG.debug("pasted " +
                 * image);
                 */

            }

        } catch (Throwable e) {
            LOG.error("invalid paste operation " + e);
        }

    }

    protected void save() {}
}
